<?php
// Set headers for API
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Log the request
error_log("🚀 Profile route accessed: " . $_SERVER['REQUEST_METHOD'] . " " . $_SERVER['REQUEST_URI']);

try {
    // Include required files
    require_once __DIR__ . '/../config/database.php';
    require_once __DIR__ . '/../controllers/ProfileController.php';
    
    // Get request method and action
    $method = $_SERVER['REQUEST_METHOD'];
    $action = isset($_GET['action']) ? $_GET['action'] : null;
    
    error_log("📡 Processing Profile: $method $action");
    
    // Create controller instance
    $profileController = new ProfileController();
    
    // Route the request
    switch(true) {
        case ($method == 'PUT' && $action == 'update-basic-info'):
            error_log("📍 Routing to update-basic-info");
            $profileController->updateBasicInfo();
            break;
            
        case ($method == 'PUT' && $action == 'update-password'):
            error_log("📍 Routing to update-password");
            $profileController->updatePassword();
            break;
            
        case ($method == 'GET' && $action == 'get-profile'):
            error_log("📍 Routing to get-profile");
            $profileController->getProfile();
            break;
            
        default:
            error_log("❌ No profile route found for: $method $action");
            http_response_code(404);
            echo json_encode([
                'error' => 'Profile route not found',
                'available_routes' => [
                    'PUT profile.php?action=update-basic-info',
                    'PUT profile.php?action=update-password',
                    'GET profile.php?action=get-profile'
                ]
            ]);
            break;
    }
    
} catch (Exception $e) {
    error_log("💥 Unhandled exception in profile route: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => 'Internal server error',
        'message' => $e->getMessage()
    ]);
}
?>