<?php
// Set headers for API
header("Content-Type: application/json; charset=UTF-8");

// For mobile apps, we can use * or specific IP
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Log the request
error_log("🚀 Auth route accessed: " . $_SERVER['REQUEST_METHOD'] . " " . $_SERVER['REQUEST_URI']);

try {
    // Include required files
    require_once __DIR__ . '/../config/database.php';
    require_once __DIR__ . '/../controllers/AuthController.php';
    require_once __DIR__ . '/../controllers/PhotoController.php';
    
    // Get request method and action
    $method = $_SERVER['REQUEST_METHOD'];
    $action = isset($_GET['action']) ? $_GET['action'] : null;
    
    error_log("📡 Processing: $method $action");
    
    // Create controller instances
    $authController = new AuthController();
    $photoController = new PhotoController();
    
    // Route the request
    switch(true) {
        // Auth routes
        case ($method == 'POST' && $action == 'signup'):
            error_log("📍 Routing to signup");
            $authController->signup();
            break;
            
        case ($method == 'POST' && $action == 'login'):
            error_log("📍 Routing to login");
            $authController->login();
            break;
            
        case ($method == 'GET' && $action == 'profile'):
            error_log("📍 Routing to profile");
            $authController->profile();
            break;
            
        case ($method == 'GET' && $action == 'logout'):
            error_log("📍 Routing to logout");
            $authController->logout();
            break;
            
        // Photo routes
        case ($method == 'POST' && $action == 'upload-photo'):
            error_log("📍 Routing to upload-photo");
            $photoController->uploadPhoto();
            break;
            
        case ($method == 'POST' && $action == 'set-main-photo'):
            error_log("📍 Routing to set-main-photo");
            $photoController->setMainPhoto();
            break;
            
        case ($method == 'POST' && $action == 'delete-photo'):
            error_log("📍 Routing to delete-photo");
            $photoController->deletePhoto();
            break;
            
        case ($method == 'GET' && $action == 'user-photos'):
            error_log("📍 Routing to user-photos");
            $photoController->getUserPhotos();
            break;
            
        default:
            error_log("❌ No route found for: $method $action");
            http_response_code(404);
            echo json_encode([
                'error' => 'Route not found',
                'available_routes' => [
                    'POST auth.php?action=signup',
                    'POST auth.php?action=login', 
                    'GET auth.php?action=profile',
                    'GET auth.php?action=logout',
                    'POST auth.php?action=upload-photo',
                    'POST auth.php?action=set-main-photo',
                    'POST auth.php?action=delete-photo',
                    'GET auth.php?action=user-photos'
                ]
            ]);
            break;
    }
    
} catch (Exception $e) {
    error_log("💥 Unhandled exception in auth route: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'error' => 'Internal server error',
        'message' => $e->getMessage()
    ]);
}
?>